<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}

class formBuilder {

	public static function newInstance() {
		return new self();
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function __construct() {
		$this->setTemplates();
		return $this;
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function setTemplates($form = "", $elements = "") {
		global $_MODULES;

		$form = $_MODULES["common"]->tpl_path . "form.htm";
		$elements = $_MODULES["common"]->tpl_path . "form.elements.htm";

	

		if (is_object($form)) {
			$this->templates["form"] = $form;
		} else {
			$this->templates["form"] = new CTemplateDynamic($form);
		}

		if (is_object($elements)) {
			$this->templates["elements"] = $elements;
		} else {
			$this->templates["elements"] = new CTemplateDynamic($elements);
		}

		return $this;
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function _t($tpl) {
		return $this->templates[$tpl];
	}
	
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function setFields($fields) {
		$this->form["fields"] = $fields;

		return $this;
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function setCaptcha($captcha) {
		$this->form["captcha"] = $captcha;

		return $this;
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function setForm($form) {
		$this->form = $form;

		return $this;
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function setValues($values) {
		$this->values = $values;

		return $this;
	}
	
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function buildForm() {
	
		return $this->_t("form")->blockReplace(
			"Form",
			array(
				"_fields"	=> $this->buildFields()
			)
		);
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function buildFields() {
		global $base;
			
		if (!is_array($this->form["fields"])) {
			return "";
		}
		
		$fields = $this->form["fields"];

		foreach ($fields as $key => $field) {

			$fields[$key] = $this->fieldProcess($field);

			switch ($field["type"]) {
				case "textbox":
					$fields[$key]["_field"] = $this->fieldTextbox($field);
				break;

				case "textarea":
					$fields[$key]["_field"] = $this->fieldTextarea($field);
				break;

				case "password":
					$fields[$key]["_field"] = $this->fieldPassword($field);
				break;

				case "select":
					$fields[$key]["_field"] = $this->fieldSelect($field);
				break;

				case "checklist":
					$fields[$key]["_field"] = $this->fieldCheckList($field);
				break;

				case "radiolist":
					$fields[$key]["_field"] = $this->fieldRadioList($field);
				break;

				case "calendar":
					$fields[$key]["_field"] = $this->fieldCalendar($field);
				break;

				case "upload":
					$fields[$key]["_field"] = $this->fieldUpload($field);
				break;

				case "subtitle":
				break;

				case "hidden":
					$val["_field"] = $this->fieldHidden($field);
					$hidden[] = $val;
					unset($fields[$key]);
				break;

				case "custom":
					$fields[$key]["_field"] = $this->fieldCustom($field);
				break;

			}


			//process the main
			switch ($field["type"]) {
				case "hidden":
				break;

				default:
					$fields[$key]["_content"] = $this->_t("form")->blockReplace(
						"Field" , 
						$fields[$key]
					);

					$fields[$key]["_icon"]	= $field["icon"] ? $this->_t("form")->blockReplace("Icon" , $field) :"";			
					$fields[$key]["_icon_class"] = $field["icon"] ? "with-icon" :"";			

				break;

				case "title":
					$fields[$key]["_content"] = $this->_t("form")->blockReplace(
						"Title" , 
						$fields[$key]
					);

					$fields[$key]["_icon"]	= $field["icon"] ? $this->_t("form")->blockReplace("Icon" , $field) :"";			

				break;
					

			}

//			$fields[$key]["_required"] = $this->formBuilderRequired($field);


			
		}		


		return $this->_t("form")->blockReplace(
			"Fields",
			array(
				"_hidden"	=> $base->html->Table(
					$this->_t("form"),
					"HiddenFields",
					$hidden
				),

				"_fields"	=> $base->html->table(
					$this->_t("form"),
					"Fields",
					$fields
				),

				"_captcha"	=> $this->fieldCaptcha($this->form["captcha"])
			)
		);

	}
	

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function fieldTextbox($field) {
		return $this->_t("elements")->blockReplace(
			"textbox",
			$field
		);
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function fieldSelect($field) {
		global $base;

		if (!is_array($field["value"])) {
			$field["value"] = explode("," , $field["value"]);
		}
	

		if ($field["select"]["groups"]) {

			if (is_array($field["options"])) {
				foreach ($field["options"] as $key => $val) {
					$options = array();

					foreach ($val as $k => $v) {
						$options[] = array(
							"title"		=> $v,
							"val"		=> $k , 
							"selected"	=> in_array($k , $field["value"]) ? $this->_t("elements")->blockReplace("selectSelected") : "",				
						);
					}
					

					$groups[] = array(
						"title"		=> $key , 
						"options"	=> $base->html->table(
							$this->_t("elements"),
							"select",
							$options
						)
					);
				}

				$_options = $base->html->table(
					$this->_t("elements"),
					"selectOpt",
					$groups
				);
			}

		} else {		
			
			if (is_array($field["options"])) {
				foreach ($field["options"] as $key => $val) {

					$options[] = array(
						"title"		=> $val,
						"val"		=> $key , 
						"selected"	=> in_array($key , $field["value"]) ? $this->_t("elements")->blockReplace("selectSelected") : "",				
					);
				}		

				$_options = $base->html->table(
					$this->_t("elements"),
					"select",
					$options
				);
			}
		}
		

		return $this->_t("elements")->blockReplace(
			"select",
			array(
				"_options"	=> $_options
			),
			$field
		);
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function fieldChecklist($field) {
		global $base;

		if (!is_array($field["value"])) {
			$field["value"] = explode("," , $field["value"]);
		}
		
		
		if (is_array($field["options"])) {
			foreach ($field["options"] as $key => $val) {

				$options[] = array(
					"title"		=> $val,
					"val"		=> $key , 
					"selected"	=> in_array($key , $field["value"]) ? $this->_t("elements")->blockReplace("checklistSelected") : "",				
				);
			}
			

		}
		

		return $this->_t("elements")->blockReplace(
			"checklist",
			array(
				"_options"	=> is_array($options) ? $base->html->table(
					$this->_t("elements"),
					"checklist",
					$options
				) : "",

				"_newline"	=> $this->attrValue($field["checklist"]["newline"],  "false"),


			),
			$field
		);
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function fieldRadioList($field) {
		global $base;
	
		if (is_array($field["options"])) {
			foreach ($field["options"] as $key => $val) {

				$options[] = array(
					"title"		=> $val,
					"val"		=> $key , 
					"selected"	=> $key == $field["value"] ? $this->_t("elements")->blockReplace("radiolistSelected") : "",				
				);
			}		
		}
		

		return $this->_t("elements")->blockReplace(
			"radiolist",
			array(
				"_options"	=> is_array($options) ? $base->html->table(
					$this->_t("elements"),
					"radiolist",
					$options
				) : "",

				"_newline"	=> $this->attrValue($field["radiolist"]["newline"],  "false"),

			),
			$field
		);

	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function fieldHidden($field) {
		return $this->_t("elements")->blockReplace(
			"hidden",
			$field
		);
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function fieldProcess(&$field) {

		//process default value
		if (!$field["value"]) {

			if ($this->values[$field["name"]]) {
				$field["value"] = $this->values[$field["name"]];
			} else {			
				$field["value"]	= $field["default"];
			}
		}

		if ($field["required"]) {
			$field["title"] .= "*";
		}

		if (defined("STP_LAYOUT_GRID") && (STP_LAYOUT_GRID == "BS3")) {
			//process sizing
			if (!$field["size"]["phone"]) {
				$field["size"]["phone"] = 12;
			}

			if (!$field["size"]["tablet"]) {
				$field["size"]["tablet"] = $field["size"]["phone"];
			}

			if (!$field["size"]["desktop"]) {
				$field["size"]["desktop"] = $field["size"]["tablet"];
			}

			if (!$field["size"]["large"]) {
				$field["size"]["large"] = $field["size"]["desktop"];
			}		

			$field["field_size_phone"]		= $field["size"]["phone"];
			$field["field_size_tablet"]		= $field["size"]["tablet"];
			$field["field_size_desktop"]	= $field["size"]["desktop"];
			$field["field_size_large"]		= $field["size"]["large"];

		} else {		
			//process sizing
			if (!$field["size"]["xs"]) {
				$field["size"]["xs"] = 12;
			}

			if (!$field["size"]["sm"]) {
				$field["size"]["sm"] = $field["size"]["xs"];
			}

			if (!$field["size"]["md"]) {
				$field["size"]["md"] = $field["size"]["sm"];
			}

			if (!$field["size"]["lg"]) {
				$field["size"]["lg"] = $field["size"]["md"];		
			}		

			
			if (!$field["size"]["xl"]) {
				$field["size"]["xl"] = $field["size"]["lg"];		
			}		

			$field["field_size_xs"]		= $field["size"]["xs"];
			$field["field_size_sm"]		= $field["size"]["sm"];
			$field["field_size_md"]		= $field["size"]["md"];
			$field["field_size_lg"]		= $field["size"]["lg"];
			$field["field_size_xl"]		= $field["size"]["xl"];
		}


		//process supported custom
		$field["_custom_class"] = $field["custom"]["class"];
		$field["_custom_tags"]	= $field["custom"]["tags"];

		//placeholder
		$field["_placeholder"] = $this->attrValue($field["placeholder"] , $field["title"]);

		return $field;				
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function fieldCustom($field) {
		return $field["custom"];
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function fieldTextarea($field) {

		$textarea = array(
			"_rows"	=>	$this->attrValue($field["textarea"]["rows"],5),
		);


		if ($field["textarea"]["html"]) {
			$this->initHtmlEditor();


			return $this->_t("elements")->blockReplace(
				"textarea_html",
				array(
					"height"	=> $this->attrValue($field["textarea"]["height"] , "200")
				),
				$field
			);
		}
		


		return $this->_t("elements")->blockReplace(
			"textarea",
			$textarea,
			$field
		);
	}


	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function fieldUpload($field) {

		$upload = array(
			//"_rows"	=>	$this->attrValue($field["textarea"]["rows"],5),
			"files"		=> $field["upload"],
			"data_url"	=> $field["upload"]["url"],		
			"size"		=> $field["upload"]["size"],
			"token"		=> $field["upload"]["token"] ? $field["upload"]["token"]  : $field["token"],
		);

		return $this->_t("elements")->blockReplace(
			"upload",
			$upload,
			$field
		);
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function fieldCaptcha($captcha) {
		if (!is_array($captcha)) {
			return "";
		}

		$this->fieldProcess($captcha);
		global $_MODULES;

		return $this->_t("elements")->blockReplace(
			"Captcha",	
			array(
				"_field"	=> $_MODULES["antispam"]->GetCaptchaField($captcha["type"] , $captcha["name"]),
			),
			$captcha

		);
	
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function fieldCalendar($field) {

		$type= array(
			"full"	=> "calendar_full",
			"date"	=> "calendar_date",
			"time"	=> "calendar_time",
		);

		return $this->_t("elements")->blockReplace(
			"calendar",
			array(
				"_type"	=> $this->_t("elements")->blockReplace(
					$type[$this->attrValue($field["calendar"]["type"] , "full")],
					$field
				)
			),
			$field
		);


	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function fieldPassword($field) {
		return $this->_t("elements")->blockReplace(
			"password",
			$field
		);
	}
	
	
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function attrValue($custom , $default) {
		if ($custom) {
			return $custom;
		} else {
			return $default;
		}
		
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function initHtmlEditor() {
		global $_MODULES;

		if ($this->initedHtmlEditor) {
			return false;
		}		

		$this->initedHtmlEditor = true;

		$_MODULES["seo"]->AppendToHead(
			$this->_t("elements")->blockReplace("htmleditor")
		);	
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	static function convertTableFieldsToXmlFields($fields_data) {

		if (is_array($fields_data)) {
			foreach ($fields_data as $key => $field) {


				switch ($field["type"]) {
					case "select":
						$field["type"] = "droplist";
						$field["empty"]	= "true";
					break;
				}
		
				unset($field["size"]);

				$fields[] = $field;
			}			
		}
		
//		debug($fields);
		return $fields;

	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	static function generateFieldsFromTableFormat($fields_data) {

		$fields = array();

		if (is_array($fields_data)) {
			foreach ($fields_data as $key => $val) {
				$field = array(
					"title"		=> $val["field_title"],
					"name"		=> $val["field_code"],
					"required"	=> $val["field_data_required"] || ($val["field_data_type"] != ""),

					"size"		=> array(
						"main"		=> $val["field_field_size"],
						"xl"		=> $val["field_field_size"],
						"lg"		=> $val["field_field_size_lg"],
						"md"		=> $val["field_field_size_md"],
						"sm"		=> $val["field_field_size_sm"],
						"xs"		=> $val["field_field_size_xs"],
					),

					"raw"		=> $val,
					
					"type"		=> $val["field_type"],
				);

				switch ($val["field_type"]) {
					case "select":
						formBuilder::generateFieldsFromTableFormatOptions($field , $val);
					break;

					case "radiolist":
					case "checklist":
						formBuilder::generateFieldsFromTableFormatOptions($field , $val);
					break;

					case "calendar":
						formBuilder::generateFieldsFromTableFormatCalendar($field , $val);
					break;
				}
				

				$fields[] = $field;
			}			
		}			

		return $fields;

	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	static private function generateFieldsFromTableFormatOptions(&$field , $val) {

		$field["options"] = array();

		switch ($val["field_options_type"]) {
			default:
				if ($val["field_options_custom"]) {
					$tmp = explode("\n" , $val["field_options_custom"]);

					$cnt = 1;
					foreach ($tmp as $key => $val) {
						$field["options"][$cnt] = trim($val);
						$cnt ++;
					}					
				}								
			
			break;
		}

		
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	static private function generateFieldsFromTableFormatCalendar(&$field , $val) {

		$field["calendar"] = array(
			"type"	=> $val["field_calendar_type"],
		);
		
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	static function array2options($values , $key , $value) {

		if (is_array($values)) {
			foreach ($values as $k => $v) {
				$_array[$v[$key]] = $v[$value];
			}
		
			return $_array;
		}	
	}
	
	
}

?>